--[[
/Traversability ratings
enum
{
	TOWN,				//instant
	ROAD,				//everything travels at 100%
	PLAINS,				//foot 90%, truck 75%, tracked 100%
	SAND,				//foot 70%, tracked 60%
	SPARSE,				//foot 70%, truck 50%, tracked 60%
	DENSE,				//foot 50% 
	SWAMP,				//foot 20%
	WATER,				//foot 15%
	HILLS,				//foot 50%, truck 50%, tracked 50%
	GROUNDBARRIER,		//only air (super dense forest, ocean, etc.)
	NS_RIVER,			//river from north to south
	EW_RIVER,			//river from east to west
	EDGEOFWORLD,		//nobody can traverse.

	//NEW (not used for border values -- traversal calculations)
	TROPICS,
	FARMLAND,
	PLAINS_ROAD,
	SPARSE_ROAD,
	FARMLAND_ROAD,
	TROPICS_ROAD,
	DENSE_ROAD,
	COASTAL,
	HILLS_ROAD,
	COASTAL_ROAD,
	SAND_ROAD,
	SWAMP_ROAD,

	//only used for text purposes and not assigned to areas (SAM sites are hard coded throughout the code)
	SPARSE_SAM_SITE,		//D15 near Drassen
	SAND_SAM_SITE,			//I8 near Tixa
	TROPICS_SAM_SITE,		//D2 near Chitzena
	MEDUNA_SAM_SITE,		//N4 in Meduna
	CAMBRIA_HOSPITAL_SITE,
	DRASSEN_AIRPORT_SITE,
	MEDUNA_AIRPORT_SITE,
	SAM_SITE,
	REFUEL_SITE,

	REBEL_HIDEOUT,
	TIXA_DUNGEON,
	CREATURE_LAIR,
	ORTA_BASEMENT,
	TUNNEL,
	SHELTER,
	ABANDONED_MINE,

#ifdef JA2UB	
//Ja25: New
	FINAL_COMPLEX,
	GUARD_POST_TYPE,
	CRASH_SITE_TYPE,
	POWER_PLANT_TYPE,
	MOUNTAINS_TYPE,
	UNKNOWN_TYPE,
#endif

	NUM_TRAVTERRAIN_TYPES
};

enum
{
	NORTH_STRATEGIC_MOVE,
	EAST_STRATEGIC_MOVE,
	SOUTH_STRATEGIC_MOVE,
	WEST_STRATEGIC_MOVE,
	THROUGH_STRATEGIC_MOVE
};

]]--


function UpdateCustomMapMovementCosts ()
--Legion2_SetBadSectorsList(7,7,1)
--UB_SetValidSector (7,7,false)
--UB_SetCustomSector (7,7,false)
--Legion2_SetTraversabilitySector (7,7,0,12)
--Legion2_SetTraversabilitySector (7,7,1,12)
--Legion2_SetTraversabilitySector (7,7,2,12)
--Legion2_SetTraversabilitySector (7,7,3,12)
--Legion2_SetTraversabilitySector (7,7,4,12)
--Legion2_SetTravelRatingSector (7,7,50)
end